____________________________________________________________________________________________

; RosAsm IOLEClientSite Web Browser Example (COM Example 4)
; --Using High Level Language Macros--

; Intial version a port of Andrew Barfield's WebBrowser Ctrl
; and a example from the PowerBasic Forum :) (JOSE ROCA)
; The goal is to simplify the code required to utilize COM in RosAsm.

; ...and many thanks to the documents produced by these four programmers:
; Ernie Murphy: http://here.is/COMinASM
; Andrew Barfield (?) *is he still around?*
; Japheth: http://www.japheth.de/
; Jose Roca on the PowerBasic Forum
; ...without their previous endeavors, I would have never succeeded here.

; - Eric Asbell - (aka RobotBob) 2004 -
; Comments inside the source are few, the real lengthy descriptions
; are in the accompanying doc.

; Changlog:
; Version is created by: (major).(minor).(revison)

; Version v0.0.1 Intial Release
____________________________________________________________________________________________

; TODO: Make a hresult handler
;#define HRESULT_SEVERITY(hr) (((hr) >> 31) & 0x1)
;HRESULT_FROM_WIN32(x) (x ? ((HRESULT) (((x) & 0x0000FFFF)
;#define HRESULT_CODE(hr) ((hr) & 0xFFFF)
;#define HRESULT_FACILITY(hr) (((hr) >> 16) & 0x1fff)
;HRESULT_FROM_NT(x) ((HRESULT) ((x) | FACILITY_NT_BIT))
; End TODO

; Uncomment these macros if you are using my QDebug.
; I have some debug output coming from the
; (right-click here to jump to code-->)IDispatch.Invoke Proc
;[OutPutDec | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutDec' #1 &0]
;[OutPutSignedDec | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutSignedDec' #1 &0]
;[OutPutHex | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutHex' #1 &0]
;[OutPutString | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutString' #1 &0]
;[OutPutError | call 'KERNEL32.GetLastError' | call 'QDEBUG.OutPutError' eax ]
;[OutPutStringLiteral |  &4=#1 | { &0: B$ &4 0 } | call 'QDEBUG.OutPutStringSimple' &0 ]
____________________________________________________________________________________________

; General purpose macros:
[push | push #1 | #+1]  [pop | pop #1 | #+1]
[mov | mov #1 #2 | #+2]
[inc | inc #1 | #+1]    [dec | dec #1 | #+1]
[On | cmp #1 #3 | jn#2 o1> | #4>L | o1:]
[call | push #L>2 | call #1]
[move | push #2 | pop #1 | #+2]
[return | mov eax #1]
[returns | mov #1 eax]

[If | cmp #1 #3 | jn#2 I0>]
[.If | cmp #1 #3 | jn#2 I1>>]
[..If | cmp #1 #3 | jn#2 I2>>]
[...If | cmp #1 #3 | jn#2 I3>>]

[Else_if | jmp I5> | I0: | cmp #1 #3 | jn#2 I0>]
[.Else_if | jmp I6>> | I1: | cmp #1 #3 | jn#2 I1>>]
[..Else_if | jmp I7>> | I2: | cmp #1 #3 | jn#2 I2>>]
[...Else_if | jmp I8>> | I3: | cmp #1 #3 | jn#2 I3>>]

[Else | Jmp I5> | I0:]
[.Else | Jmp I6>> | I1:]
[..Else | Jmp I7>> | I2:]
[...Else | Jmp I8>> | I3:]

[End_if | I0: | I5:]
[.End_if | I1: | I6:]
[..End_if | I2: | I7:]
[...End_if | I3: | I8:]

; If_Or eax = 1, eax = 5, eax =122
[If_Or    | cmp #1 #3 | j#2 O0> | #+3 | jmp I0> | O0:]
[.If_Or   | cmp #1 #3 | j#2 O1> | #+3 | jmp I1> | O1:]
[..If_Or  | cmp #1 #3 | j#2 O2> | #+3 | jmp I2> | O2:]
[...If_Or | cmp #1 #3 | j#2 O3> | #+3 | jmp I3> | O3:]

; If_And eax = 1, ebx = 5, ecx =122
[If_And    | cmp #1 #3 | jn#2 I0> | #3]
[.If_And   | cmp #1 #3 | jn#2 I1> | #3]
[..If_And  | cmp #1 #3 | jn#2 I2> | #3]
[...If_And | cmp #1 #3 | jn#2 I3> | #3]

[While | W0: | cmp #1 #3 | jn#2 W9>]
[End_While | jmp W0< | W9:]

[.While | X0: | cmp #1 #3 | jn#2 X9>>]
[.End_While | jmp X0<< | X9:]

[Do | D0:]
[Loop_Until | cmp #1 #3 | jn#2 D0<]
[Do_Loop | Loop D0<]

[.Do | E0:]
[.Loop_Until | cmp #1 #3 | jn#2 E0<<]                   ; long
[.Do_Loop | Loop E0<]

_________________________________________________________________________________________
; Added Equates for more HLL-style in comparison Macros:
[= e   < b    > a    =< be    <= be    => ae    >= ae    <> ne]
_________________________________________________________________________________________
_________________________________________________________________________________________
; Proc Macros and Equates. Internal storages are:
; &1 <<< Size of Argument(s) (for ending Ret n, in EndP). Set by Argument(s)
; &2 <<< Size of Local (for Stack Management). Set by Local
; &3 <<< What to pop before ret. Set by Uses.

[Proc | &1=0 | &2=0 | &3= | #1 | push ebp | mov ebp esp]
[Exit | jmp P9>>]
[Arguments | {#1 Arg#x} | #+1 | &1=SizeOf#x]
[Argument  | {#1 Arg#x} | #+1 | &1=SizeOf#x]
[Local | {#1 Local#x} | #+1 | sub esp SizeOf#x | &2=SizeOf#x]
[StrucPtrs | {#3 ebp+#2+#F} | #+2]
[Structure | {#1 ebp-&2-4} | sub esp #2+4 | mov D$#1 esp | StrucPtrs 0-&2-#2-4 #L>3]
[Uses | push #1>L | &3=pop #L>1]
[EndP | P9: | &3 | mov esp ebp | pop ebp | ret &1]

; For pointing to transmitted parameters (upper "Arg#x" fall here):
[Arg1 ebp+8    Arg2 ebp+12    Arg3 ebp+16    Arg4 ebp+20   Arg5 ebp+24
 Arg6 ebp+28   Arg7 ebp+32    Arg8 ebp+36    Arg9 ebp+40   Arg10 ebp+44]

; For pointing Local Stack declared data (upper "Local#x" fall here):
[Local1 ebp-4     Local2 ebp-8     Local3 ebp-12    Local4 ebp-16    Local5 ebp-20
 Local6 ebp-24    Local7 ebp-28    Local8 ebp-32    Local9 ebp-36    Local10 ebp-40]

; To help preventing from stack sizes' mistakes (upper "SizeOf#x" fall here):
[SizeOf1 4     SizeOf2 8     SizeOf3 12    SizeOf4 16    SizeOf5 20
 SizeOf6 24    SizeOf7 28    SizeOf8 32    SizeOf9 36    SizeOf10 40]
____________________________________________________________________________________________

; COM Related Macros
; For Testing hResults
[.If_Failed | test eax eax | jns I1>]
[..If_Failed | test eax eax | jns I2>]
[...If_Failed | test eax eax | jns I3>]
[.If_Success | test eax eax | js I1>]
[..If_Success | test eax eax | js I2>]
[...If_Success | test eax eax | js I3>]

; For cmp eax 0 usage
[.If_Zero | test #1 #1 | jnz I1>]
[..If_Zero | test #1 #1 | jnz I2>]
[...If_Zero | test #1 #1 | jnz I3>]

; Example :  iCall Lock D$BackSurfacePtr &NULL DDSURFACEDESC DDLOCK_WAIT &NULL
[iCall | mov edx #2 | mov edx D$edx | push #L>3 | push #2 | call D$edx+#1 ]
____________________________________________________________________________________________

[MemError:          B$ "Cannot Allocate Memory" 0]
[CannotLoadError:   B$ "Cannot Load Internet Explorer!" 0]
[MyClass:           B$ "RosBrow_Class" 0]
[BrowserTitle:      B$ "RosAsm IOLEClientSite Web Browser Example (COM Example 4)" 0]

[WindowClassEx: ; Window ClassEx Structure
 cbSize: len style: 3  lpfnWndProc: MainWindowProc  cbClsExtra: 0  cbWndExtra: 0
 hInstance: 0  hIcon: 0  hCursor: 0  hbrBackground: 6
 lpszMenuName: 0  lpszClassName: MyClass hIconSm: 0]

[FirstMessage: 0 #7] ; For "GetMessage"
____________________________________________________________________________________________

; Virtual Table Structures
; they are just pointer tables...
[vtblIUnknown:
QueryInterface
AddRef
Release]

[vtblIOleWindow:
QueryInterface
AddRef
Release
IOleWindow.GetWindow
IOleWindow.ContextSensitiveHelp]

[vtblIOleClientSite:
QueryInterface
AddRef
Release
IOleClientSite.SaveObject
IOleClientSite.GetMoniker
IOleClientSite.GetContainer
IOleClientSite.ShowObject
IOleClientSite.OnShowWindow
IOleClientSite.RequestNewObjectLayout]

[vtblIOleInPlaceSite:
QueryInterface
AddRef
Release
IOleWindow.GetWindow
IOleWindow.ContextSensitiveHelp
IOleInPlaceSite.CanInPlaceActivate
IOleInPlaceSite.OnInPlaceActivate
IOleInPlaceSite.OnUIActivate
IOleInPlaceSite.GetWindowContext
IOleInPlaceSite.Scroll
IOleInPlaceSite.OnUIDeactivate
IOleInPlaceSite.OnInPlaceDeactivate
IOleInPlaceSite.DiscardUndoState
IOleInPlaceSite.DeactivateAndUndo
IOleInPlaceSite.OnPosRectChange]

[vtblIDispatch:
QueryInterface
AddRef
Release
IDispatch.GetTypeInfoCount
IDispatch.GetTypeInfo
IDispatch.GetIDsOfNames
IDispatch.Invoke]

[vtblIDocHostUIHandler:
QueryInterface
AddRef
Release
IDocHostUIHandler.ShowContextMenu
IDocHostUIHandler.GetHostInfo
IDocHostUIHandler.ShowUI
IDocHostUIHandler.HideUI
IDocHostUIHandler.UpdateUI
IDocHostUIHandler.EnableModeless
IDocHostUIHandler.OnDocWindowActivate
IDocHostUIHandler.OnFrameWindowActivate
IDocHostUIHandler.ResizeBorder
IDocHostUIHandler.TranslateAccelerator
IDocHostUIHandler.GetOptionKeyPath
IDocHostUIHandler.GetDropTarget
IDocHostUIHandler.GetExternal
IDocHostUIHandler.TranslateUrl
IDocHostUIHandler.FilterDataObject]

[vtblIDocHostShowUI:
QueryInterface
AddRef
Release
IDocHostShowUI.ShowHelp
IDocHostShowUI.ShowMessage]
____________________________________________________________________________________________

; Vtable Displacements
[IUNKNOWN_QUERYINTERFACE 0
 IUNKNOWN_ADDREF 04
 IUNKNOWN_RELEASE 08]

[IOLEWINDOWIOLEWINDOW.GETWINDOW 0C
 IOLEWINDOWIOLEWINDOW.CONTEXTSENSITIVEHELP 010]

[IOLECLIENTSITE_SAVEOBJECT 0C
 IOLECLIENTSITE_GETMONIKER 010
 IOLECLIENTSITE_GETCONTAINER 014
 IOLECLIENTSITE_SHOWOBJECT 018
 IOLECLIENTSITE_ONSHOWWINDOW 01C
 IOLECLIENTSITE_REQUESTNEWOBJECTLAYOUT 020]

[IOLEWINDOW_GETWINDOW 0C
 IOLEWINDOW_CONTEXTSENSITIVEHELP 010
 IOLEINPLACESITE_CANINPLACEACTIVATE 014
 IOLEINPLACESITE_ONINPLACEACTIVATE 018
 IOLEINPLACESITE_ONUIACTIVATE 01C
 IOLEINPLACESITE_GETWINDOWCONTEXT 020
 IOLEINPLACESITE_SCROLL 024
 IOLEINPLACESITE_ONUIDEACTIVATE 028
 IOLEINPLACESITE_ONINPLACEDEACTIVATE 02C
 IOLEINPLACESITE_DISCARDUNDOSTATE 030
 IOLEINPLACESITE_DEACTIVATEANDUNDO 034
 IOLEINPLACESITE_ONPOSRECTCHANGE 038]

[IDISPATCH_GETTYPEINFOCOUNT 0C
 IDISPATCH_GETTYPEINFO 010
 IDISPATCH_GETIDSOFNAMES 014
 IDISPATCH_INVOKE 018]

[IDOCHOSTUIHANDLER_SHOWCONTEXTMENU 0C
 IDOCHOSTUIHANDLER_GETHOSTINFO 010
 IDOCHOSTUIHANDLER_SHOWUI 014
 IDOCHOSTUIHANDLER_HIDEUI 018
 IDOCHOSTUIHANDLER_UPDATEUI 01C
 IDOCHOSTUIHANDLER_ENABLEMODELESS 020
 IDOCHOSTUIHANDLER_ONDOCWINDOWACTIVATE 024
 IDOCHOSTUIHANDLER_ONFRAMEWINDOWACTIVATE 028
 IDOCHOSTUIHANDLER_RESIZEBORDER 02C
 IDOCHOSTUIHANDLER_TRANSLATEACCELERATOR 030
 IDOCHOSTUIHANDLER_GETOPTIONKEYPATH 034
 IDOCHOSTUIHANDLER_GETDROPTARGET 038
 IDOCHOSTUIHANDLER_GETEXTERNAL 03C
 IDOCHOSTUIHANDLER_TRANSLATEURL 040
 IDOCHOSTUIHANDLER_FILTERDATAOBJECT 044]

[IDOCHOSTSHOWUI_SHOWHELP 0C
 IDOCHOSTSHOWUI_SHOWMESSAGE 010]

 [ICONNECTIONPOINT_GETCONNECTIONINTERFACE 0C
 ICONNECTIONPOINT_GETCONNECTIONPOINTCONTAINER 010
 ICONNECTIONPOINT_ADVISE 014
 ICONNECTIONPOINT_UNADVISE 018
 ICONNECTIONPOINT_ENUMCONNECTIONS 01C]

 [ICONNECTIONPOINTCONTAINER_ENUMCONNECTIONPOINTS 0C
 ICONNECTIONPOINTCONTAINER_FINDCONECTIONPOINT 010]

[IOLEOBJECT_SETCLIENTSITE 0C
 IOLEOBJECT_GETCLIENTSITE 010
 IOLEOBJECT_SETHOSTNAMES 014
 IOLEOBJECT_CLOSE 018
 IOLEOBJECT_SETMONIKER 01C
 IOLEOBJECT_GETMONIKER 020
 IOLEOBJECT_INITFROMDATA 024
 IOLEOBJECT_GETCLIPBOARDDATA 028
 IOLEOBJECT_DOVERB 02C
 IOLEOBJECT_ENUMVERBS 030
 IOLEOBJECT_UPDATE 034
 IOLEOBJECT_ISUPTODATE 038
 IOLEOBJECT_GETUSERCLASSID 03C
 IOLEOBJECT_GETUSERTYPE 040
 IOLEOBJECT_SETEXTENT 044
 IOLEOBJECT_GETEXTENT 048
 IOLEOBJECT_ADVISE 04C
 IOLEOBJECT_UNADVISE 050
 IOLEOBJECT_ENUMADVISE 054
 IOLEOBJECT_GETMISCSTATUS 058
 IOLEOBJECT_SETCOLORSCHEME 05C]

 [IWEBBROWSER2_GETTYPEINFOCOUNT 0C
 IWEBBROWSER2_GETTYPEINFO 010
 IWEBBROWSER2_GETIDSOFNAMES 014
 IWEBBROWSER2_INVOKE 018
 IWEBBROWSER2_GOBACK 01C
 IWEBBROWSER2_GOFORWARD 020
 IWEBBROWSER2_GOHOME 024
 IWEBBROWSER2_GOSEARCH 028
 IWEBBROWSER2_NAVIGATE 02C
 IWEBBROWSER2_REFRESH 030
 IWEBBROWSER2_REFRESH2 034
 IWEBBROWSER2_STOP 038
 IWEBBROWSER2_GETAPPLICATION 03C
 IWEBBROWSER2_GETPARENT 040
 IWEBBROWSER2_GETCONTAINER 044
 IWEBBROWSER2_GETDOCUMENT 048
 IWEBBROWSER2_GETTOPLEVELCONTAINER 04C
 IWEBBROWSER2_GETTYPE 050
 IWEBBROWSER2_GETLEFT 054
 IWEBBROWSER2_PUTLEFT 058
 IWEBBROWSER2_GETTOP 05C
 IWEBBROWSER2_PUTTOP 060
 IWEBBROWSER2_GETWIDTH 064
 IWEBBROWSER2_PUTWIDTH 068
 IWEBBROWSER2_GETHEIGHT 06C
 IWEBBROWSER2_PUTHEIGHT 070
 IWEBBROWSER2_GETLOCATIONNAME 074
 IWEBBROWSER2_GETLOCATIONURL 078
 IWEBBROWSER2_GETBUSY 07C
 IWEBBROWSER2_QUIT 080
 IWEBBROWSER2_CLIENTTOWINDOW 084
 IWEBBROWSER2_PUTPROPERTY 088
 IWEBBROWSER2_GETPROPERTY 08C
 IWEBBROWSER2_GETNAME 090
 IWEBBROWSER2_GETHWND 094
 IWEBBROWSER2_GETFULLNAME 098
 IWEBBROWSER2_GETPATH 09C
 IWEBBROWSER2_GETVISIBLE 0A0
 IWEBBROWSER2_PUTVISIBLE 0A4
 IWEBBROWSER2_GETSTATUSBAR 0A8
 IWEBBROWSER2_PUTSTATUSBAR 0AC
 IWEBBROWSER2_GETSTATUSTEXT 0B0
 IWEBBROWSER2_PUTSTATUSTEXT 0B4
 IWEBBROWSER2_GETTOOLBAR 0B8
 IWEBBROWSER2_PUTTOOLBAR 0BC
 IWEBBROWSER2_GETMENUBAR 0C0
 IWEBBROWSER2_PUTMENUBAR 0C4
 IWEBBROWSER2_GETFULLSCREEN 0C8
 IWEBBROWSER2_PUTFULLSCREEN 0CC
 IWEBBROWSER2_NAVIGATE2 0D0
 IWEBBROWSER2_QUERYSTATUSWB 0D4
 IWEBBROWSER2_EXECWB 0D8
 IWEBBROWSER2_SHOWBROWSERBAR 0DC
 IWEBBROWSER2_GETREADYSTATE 0E0
 IWEBBROWSER2_GETOFFLINE 0E4
 IWEBBROWSER2_PUTOFFLINE 0E8
 IWEBBROWSER2_GETSILENT 0EC
 IWEBBROWSER2_PUTSILENT 0F0
 IWEBBROWSER2_GETREGISTERASBROWSER 0F4
 IWEBBROWSER2_PUTREGISTERASBROWSER 0F8
 IWEBBROWSER2_GETREGISTERASDROPTARGET 0FC
 IWEBBROWSER2_PUTREGISTERASDROPTARGET 0100
 IWEBBROWSER2_GETTHEATERMODE 0104
 IWEBBROWSER2_PUTTHEATERMODE 0108
 IWEBBROWSER2_GETADDRESSBAR 010C
 IWEBBROWSER2_PUTADDRESSBAR 0110
 IWEBBROWSER2_GETRESIZABLE 0114
 IWEBBROWSER2_PUTRESIZABLE 0118]
____________________________________________________________________________________________
; GUIDS

;{8856F961-340A-11D0-A96B-00C04FD705A2}
[CLSID_WebBrowser:
@Data1: D$ 08856F961H
@Data2: W$ 0340AH
@Data3: W$ 011D0H]
[@Data4: B$ 0A9 06B 00 0C0 04F 0D7 05 0A2]

;{00000000-0000-0000-C000-000000000046}
[IID_IUnknown:
@Data1: D$ 000000000H
@Data2: W$ 00000H
@Data3: W$ 00000H]
[@Data4: B$ 0C0 000 000 000 000 000 000 046]

;{00020400-0000-0000-C000-000000000046}
[IID_IDispatch:
@Data1: D$ 000020400H
@Data2: W$ 00000H
@Data3: W$ 00000H]
[@Data4: B$ 0C0 000 000 000 000 000 000 046]

;{00000112-0000-0000-C000-000000000046}
[IID_IOleObject:
@Data1: D$ 000000112H
@Data2: W$ 00000H
@Data3: W$ 00000H]
[@Data4: B$ 0C0 000 000 000 000 000 000 046]

;{00000118-0000-0000-C000-000000000046}
[IID_IOleClientSite:
@Data1: D$ 000000118H
@Data2: W$ 00000H
@Data3: W$ 00000H]
[@Data4: B$ 0C0 000 000 000 000 000 000 046]

;{00000119-0000-0000-C000-000000000046}
[IID_IOleInPlaceSite:
@Data1: D$ 000000119H
@Data2: W$ 00000H
@Data3: W$ 00000H]
[@Data4: B$ 0C0 000 000 000 000 000 000 046]


[IID_IDocHostUIHandler:
@Data1: D$ 0BD3F23C0H
@Data2: W$ 0d43EH
@Data3: W$ 011CFH
@Data4: B$ 089H, 03BH, 000H, 0AAH, 000H, 0BDH, 0CEH, 01AH]

[IID_IDocHostShowUI:
@Data1: D$ 0C4D244B0H
@Data2: W$ 0d43EH
@Data3: W$ 011CFH
@Data4: B$ 089H, 03BH, 000H, 0AAH, 000H, 0BDH, 0CEH, 01AH]

;{34A715A0-6587-11D0-924A-0020AFC7AC4D}
[DIID_DWebBrowserEvents2:
@Data1: D$ 034A715A0H
@Data2: W$ 06587H
@Data3: W$ 011D0H]
[@Data4: B$ 092 04A 000 020 0AF 0C7 0AC 04D]

;{EAB22AC1-30C1-11CF-A7EB-0000C05BAE0B}
[IID_IWebBrowser:
@Data1: D$ 0EAB22AC1H
@Data2: W$ 030C1H
@Data3: W$ 011CFH]
[@Data4: B$ 0A7 0EB 000 000 0C0 05B 0AE 0B]

;{00000113-0000-0000-C000-000000000046}
[IID_IOleInPlaceObject:
@Data1: D$ 000000113H
@Data2: W$ 00000H
@Data3: W$ 00000H]
[@Data4: B$ 0C0 000 000 000 000 000 000 046]

;{B196B284-BAB4-101A-B69C-00AA00341D07}
[IID_IConnectionPointContainer:
Data1: D$ 0B196B284H
Data2: W$ 0BAB4H
Data3: W$ 0101AH]
[Data4: B$ 0B6 09C 00 0AA 00 034 01D 07]
____________________________________________________________________________________________

; Data
[IOleInPlaceObjectPointer: D$ 0]
[IOleObjectPointer: D$ 0]
[BrowserPointer: D$ 0]
[BooleanInPlaceActive: B$ 0]
[ReferenceCount: D$ 0]
[WBCookie: D$ 0]
[MainWindow: D$ 0]
[StatusWindow: D$ 0]
[MyURL: B$ "http://betov.free.fr" 0]
[ClientSiteObjectPtr: D$ ?]
[hHeap: D$ ? ]
[hWnd: D$ ? #03FE]

[pif: D$ 0]
[BrowserRECT:
 @BrowserRECT.left: D$ 0
 @BrowserRECT.top: D$ 0
 @BrowserRECT.right: D$ 0
 @BrowserRECT.bottom: D$ 0]

[BrowserMSG: D$ 0]
[URL: W$ ? #0208]
[tmpvar: D$ ?]
____________________________________________________________________________________________

Proc CreateEmbeddedBrowser:
    Arguments @hWin, @hStatusWin

    move D$MainWindow D@hWin
    move D$StatusWindow D@hStatusWin

    ; Create the Client Site Object
    call CreateClientSiteObject pif
    ; Did we create an object?
    .If_Failed
        call 'USER32.MessageBoxA' 0 MemError BrowserTitle &MB_ICONERROR
        Exit
    .End_if

    ; Create an instance of the WebBrowser Control!
    call 'ole32.CoCreateInstance' CLSID_WebBrowser &NULL &CLSCTX_INPROC_SERVER+&CLSCTX_INPROC_HANDLER,
                                  IID_IOleObject IOleObjectPointer
    ; Did we fail ?
    .If_Failed
        call 'USER32.MessageBoxA' 0 CannotLoadError BrowserTitle &MB_ICONERROR
        Exit
    .End_if

    ; Copy a pointer to the ClientSite objects vtblIOleClientSite into eax.
    mov eax D$pif | lea eax D$eax+010

    ; Set the WebBrowsers ClientSite to our object.
    iCall IOLEOBJECT_SETCLIENTSITE D$IOleObjectPointer eax
    .If_Failed
        Exit
    .End_if

    ; Get the diminsions of our window
    call 'USER32.GetClientRect' D$MainWindow BrowserRECT

    ; And tell the WebBrowser control the size of its new home.
    iCall IOLEOBJECT_DOVERB D$IOleObjectPointer &OLEIVERB_INPLACEACTIVATE D$BrowserMSG,
                            D$pif 0 D$MainWindow BrowserRECT
    .If_Failed
        Exit
    .End_if

    ; Get an pointer to the WebBrowsers Interface.
    iCall IUNKNOWN_QUERYINTERFACE D$IOleObjectPointer IID_IWebBrowser BrowserPointer
    .If_Failed
        Exit
    .End_if

    ; If we were succesful, Request that we recieve events
    .If D$BrowserPointer <> 0
        call AdviseWBEventSink D$pif
    .Else
        Exit
    .End_if

    ; Get a pointer to the IOleInPlaceObject Interface on th Browser Pointer
    iCall IUNKNOWN_QUERYINTERFACE D$BrowserPointer IID_IOleInPlaceObject IOleInPlaceObjectPointer
    .If_Failed
        Exit
    .End_If

    ; Convert our ascii url to unicode.
    ; Note: you can declare it like this [url: U$ "http://" 0 ]
    ; But not always is this possible, so I do it the hard way in this case :)
    call 'KERNEL32.MultiByteToWideChar' &CP_ACP 0 MyURL 0-01 URL 0208
    .If_Zero eax
        jmp Q9>
    .End_If

    ; Call a function in the WebBrowser Object! Navigate.
    iCall IWEBBROWSER2_NAVIGATE D$BrowserPointer URL D$tmpvar D$tmpvar D$tmpvar D$tmpvar
    .If_Failed
        jmp Q9>
    .End_if

    return 0
EndP

Q9: ; Exit Failure
   return &E_FAIL
EndP
____________________________________________________________________________________________

DestroyBrowser:

    ; Releases object pointers and Stops events.
    .If D$IOleInPlaceObjectPointer = 0
        iCall IUNKNOWN_RELEASE D$IOleInPlaceObjectPointer
        mov D$IOleInPlaceObjectPointer 0
    .End_if

    .If D$BrowserPointer = 0
        call UnadviseWBEventSink

        iCall IUNKNOWN_RELEASE D$BrowserPointer
        mov D$BrowserPointer 0
    .End_if

    .If D$IOleObjectPointer <> 0
        iCall IUNKNOWN_RELEASE D$IOleObjectPointer
        mov D$IOleObjectPointer 0
    .End_if

ret
____________________________________________________________________________________________

Proc CreateClientSiteObject:
    Argument @pobj
    Uses ebx

    mov eax D@pobj
    mov D$eax  0

    call 'KERNEL32.GetProcessHeap'
    returns D$hHeap

    call 'KERNEL32.HeapAlloc' eax &HEAP_ZERO_MEMORY  038
    returns D$ClientSiteObjectPtr
    .If_Zero eax
        return &E_FAIL
        Exit
    .End_If

    mov ebx eax
    mov eax D@pobj
    mov D$eax  ebx
    mov D$ReferenceCount 0

    mov D$ebx  vtblIUnknown
    mov D$ebx+04 0
    mov D$ebx+08 vtblIOleWindow
    mov D$ebx+0C 8
    mov D$ebx+010 vtblIOleClientSite
    mov D$ebx+014 16
    mov D$ebx+018 vtblIOleInPlaceSite
    mov D$ebx+01C 24
    mov D$ebx+020 vtblIDispatch
    mov D$ebx+024 32
    mov D$ebx+028 vtblIDocHostUIHandler
    mov D$ebx+02C 40
    mov D$ebx+030 vtblIDocHostShowUI
    mov D$ebx+034 48

    return &S_OK

EndP

____________________________________________________________________________________________

Proc ResizeBrowser:
    Structure @RECT 16, @leftDis 0,  @topDis 4,  @rightDis 8,  @bottomDis 12

    .If D$BrowserPointer <> 0

        ..If B$BooleanInPlaceActive <> 0

            ...If D$IOleInPlaceObjectPointer <> 0

                call 'USER32.GetClientRect' D$MainWindow D@RECT
                iCall IOLEINPLACESITE_ONUIACTIVATE D$IOleInPlaceObjectPointer D@RECT D@RECT

           ...End_if

        ..End_if

    .End_if
Endp
____________________________________________________________________________________________

; The next 3 procs are calls to allow us to receive *events* from the webbrowser.
; Events like DownloadComplete... It allows us to receive feedback from the control
; we are using

Proc AdviseWBEventSink:
    Argument @pif
    LOCAL @ConnPoint , @iTemp

    If D$BrowserPointer <> 0
        lea eax D@ConnPoint
        call GetConnectionPoint D$BrowserPointer DIID_DWebBrowserEvents2 eax
        .If_Success
            mov eax D@pif | lea eax D$eax+020 | mov D@iTemp eax

            iCall ICONNECTIONPOINT_ADVISE D@ConnPoint D@iTemp WBCookie
            iCall IUNKNOWN_RELEASE D@ConnPoint
        .End_if
    End_if
EndP
____________________________________________________________________________________________

Proc UnadviseWBEventSink:
    LOCAL @ConnPoint

    If  D$BrowserPointer <> 0
        .If D$WBCookie <> 0

        call GetConnectionPoint D$BrowserPointer DIID_DWebBrowserEvents2 D@ConnPoint
        .If_Failed
            Exit
        .End_if

        iCall ICONNECTIONPOINT_UNADVISE D@ConnPoint D$WBCookie
        iCall IUNKNOWN_RELEASE D@ConnPoint

        dec D$WBCookie
        .End_If
    End_if
EndP
____________________________________________________________________________________________

Proc GetConnectionPoint:
    Arguments @pUnk, @riid, @ppCP
    [@ConnPoint: D$ ?]

    return &E_FAIL

    .If D$BrowserPointer <> 0

        iCall IUNKNOWN_QUERYINTERFACE D@pUnk IID_IConnectionPointContainer @ConnPoint
        ..If_Failed
            return &E_FAIL
            Exit
        ..End_If

        iCall ICONNECTIONPOINTCONTAINER_FINDCONECTIONPOINT  D@ConnPoint D@riid D@ppCP
        push eax

        iCall IUNKNOWN_RELEASE D@ConnPoint eax
        pop eax

    .End_if
EndP
____________________________________________________________________________________________

; a macro just to make this Proc a little more readable
[GetInterface | mov ecx #1 | lea eax #1 | mov ebx D$ebp+010 | mov D$ebx eax | push D$ebp+08 | call D$ecx+04]

; Returns a pointer to a specified interface on an object to which a client currently
; holds an interface pointer. This function must call IUnknown::AddRef on the pointer it returns.
Proc QueryInterface:
    Arguments @pif, @riid, @ppv
    LOCAL @interface
    push ebx ecx

    call 'ole32.IsEqualGUID' D@riid IID_IUnknown
    test eax eax | mov D@interface 01 | jne L1>>

    call 'ole32.IsEqualGUID' D@riid IID_IOleClientSite
    test eax eax | mov D@interface 02 | jne L1>>

    call 'ole32.IsEqualGUID' D@riid IID_IDocHostUIHandler
    test eax eax | mov D@interface 03 | jne L1>

    call 'ole32.IsEqualGUID' D@riid IID_IDocHostShowUI
    test eax eax | mov D@interface 04 | jne L1>

    call 'ole32.IsEqualGUID' D@riid IID_IOleInPlaceSite
    test eax eax | mov D@interface 05 | jne L1>

    call 'ole32.IsEqualGUID' D@riid IID_IDispatch
    test eax eax | mov D@interface 06 | jne L1>

    call 'ole32.IsEqualGUID' D@riid DIID_DWebBrowserEvents2
    test eax eax | mov D@interface 06 | jne L1>

    jmp E1>> ; Error

L1:
    mov eax D$ebp+08
    sub eax D$eax+04

    .If D@interface = 1
        GetInterface D$eax

    .Else_If D@interface = 2
        GetInterface D$eax+010

    .Else_If D@interface = 3
        GetInterface D$eax+028

    .Else_If D@interface = 4
        GetInterface D$eax+030

    .Else_If D@interface = 5
        GetInterface D$eax+018

    .Else_If D@interface = 6
        GetInterface D$eax+020

    .End_if

    return &S_OK
    pop ecx | pop ebx
    jmp P9>

E1: ; Jump Here if not found...
    mov eax D$ebp+010
    mov D$eax  0
    return &E_NOINTERFACE
    pop ecx | pop ebx
EndP
____________________________________________________________________________________________

;The IUnknown::AddRef method increments the reference count for an interface on an object.
;It should be called for every new copy of a pointer to an interface on a given object.
Proc AddRef:
    Argument @pif
    call 'KERNEL32.InterlockedIncrement' ReferenceCount
    return D$ReferenceCount
EndP
____________________________________________________________________________________________

;Decrements the reference count for the calling interface on a object. If the reference
;count on the object falls to 0, the object is freed from memory.
Proc Release:
    Argument @pif

    call 'KERNEL32.InterlockedDecrement' ReferenceCount
    .If D$ReferenceCount  = 0
        mov eax D@pif
        mov eax D$eax
        call 'KERNEL32.GetProcessHeap' 0 eax
        call 'KERNEL32.HeapFree' eax
    .End_if

    return D$ReferenceCount
EndP
____________________________________________________________________________________________

;Returns the window handle to one of the windows participating in in-place activation
;(frame, document, parent, or in-place object window).
Proc IOleWindow.GetWindow:
    Arguments @pif, @phwnd
    Uses ebx

        mov eax D@phwnd
        mov ebx D$MainWindow
        mov D$eax  ebx

        return &S_OK
EndP
____________________________________________________________________________________________


;Determines whether context-sensitive help mode should be entered during an
;in-place activation session
Proc IOleWindow.ContextSensitiveHelp:
    Arguments @pif, @fEnterMode

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Saves the object associated with the client site. This function is synchronous; by the time
;it returns, the save will be completed.
Proc IOleClientSite.SaveObject:
    Argument @pif

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Returns a moniker to an object's client site. An object can force the assignment of its own
;or its container's moniker by specifying a value for dwAssign.
Proc IOleClientSite.GetMoniker:
    Arguments @pif, @dwAssign, @dwWhichMoniker, @ppmk

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Returns a pointer to the container's IOleContainer interface.
Proc IOleClientSite.GetContainer:
    Arguments @pif, @ppContainer

    mov eax D@ppContainer | mov D$eax  0
    return &E_NOINTERFACE
EndP
___________________________________________________________________________________________

; Tells the container to position the object so it is visible to the user. This method
; ensures that the container itself is visible and not minimized.
Proc IOleClientSite.ShowObject:
    Argument @pif

    return &S_OK
EndP
____________________________________________________________________________________________

; Notifies a container when an embedded object's window is about to become visible or invisible.
; This method does not apply to an object that is activated in place and therefore has no window
; separate from that of its container.
Proc IOleClientSite.OnShowWindow:
    Arguments @pif, @fShow

    return &S_OK
EndP
____________________________________________________________________________________________

;Asks container to allocate more or less space for displaying an embedded object.
Proc IOleClientSite.RequestNewObjectLayout:
    Argument @pif

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Determines whether or not the container can activate the object in place.
Proc IOleInPlaceSite.CanInPlaceActivate:
    Argument @pif

    return &S_OK
EndP
____________________________________________________________________________________________

;Notifies the container that one of its objects is being activated in place.
Proc IOleInPlaceSite.OnInPlaceActivate:
    Argument @pif

    mov B$BooleanInPlaceActive &TRUE
    return &S_OK
EndP
____________________________________________________________________________________________

; Notifies the container that the object is about to be activated in place and that the
; object is going to replace the container's main menu with an in-place composite menu
Proc IOleInPlaceSite.OnUIActivate:
    Argument @pif

    return &S_OK
EndP
____________________________________________________________________________________________

; Enables the in-place object to retrieve the window interfaces that form the window
; object hierarchy, and the position in the parent window where the object's in-place
; activation window should be placed.
Proc IOleInPlaceSite.GetWindowContext:
    Arguments @pif, @ppFrame, @ppDoc, @lprcPosRect, @lprcClipRect, @lpFrameInfo

    call 'USER32.GetClientRect' D$MainWindow D@lprcPosRect
    call 'USER32.GetClientRect' D$MainWindow D@lprcClipRect

    return &S_OK
EndP
____________________________________________________________________________________________

;Tells the container to scroll the view of the object by a specified number of pixels.
Proc IOleInPlaceSite.Scroll:
    Arguments @pif, @scrollExtent

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Notifies the container on deactivation that it should reinstall its user interface and
;take focus, and whether or not the object has an undoable state.
Proc IOleInPlaceSite.OnUIDeactivate:
    Arguments @pif, @fUndoable

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Notifies the container that the object is no longer active in place.
Proc IOleInPlaceSite.OnInPlaceDeactivate:
    Argument @pif

    mov B$BooleanInPlaceActive 0

    .If D$IOleInPlaceObjectPointer <> 0
        iCall IUNKNOWN_RELEASE D$IOleInPlaceObjectPointer
        mov D$IOleInPlaceObjectPointer 0
    .End_if

    return &S_OK
EndP
____________________________________________________________________________________________

; Tells the container that the object no longer has any undo state and that the container
; should not call IOleInPlaceObject.ReActivateAndUndo
Proc IOleInPlaceSite.DiscardUndoState:
    Argument @pif

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

; Causes the container to end the in-place session, deactivate the object,
; and revert to its own saved undo state.
Proc IOleInPlaceSite.DeactivateAndUndo:
    Argument @pif

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

; Indicates the object's extents have changed
Proc IOleInPlaceSite.OnPosRectChange:
    Arguments @pif, @lprcPosRect

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

; Retrieves the number of type information interfaces that
; an object provides (either 0 or 1).
Proc IDispatch.GetTypeInfoCount:
    Arguments @pif, pctinfo

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Retrieves the type information for an object, which can then be used to get the type
;information for an interface.
Proc IDispatch.GetTypeInfo:
    Arguments @pif, @iTInfo, @lcid, @ppTInfo

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Maps a single member and an optional set of argument names to a corresponding set of
;integer DISPIDs, which can be used on subsequent calls to IDispatch::Invoke
Proc IDispatch.GetIDsOfNames:
    Arguments @pif, @riid, @rgszNames, @cNames, @lcid, @rgDispId

    return &DISP_E_UNKNOWNINTERFACE
EndP
____________________________________________________________________________________________

; Provides access to properties and methods exposed by an object.
Proc IDispatch.Invoke:
    Arguments @pif, @dispIdMember, @riid, @lcid, @wFlags, @pDispParams, @pVarResult, @pExcepInfo, @puArgErr

    ; These are the DWebBrowserEvents2 Events.
    .If D@dispIdMember = &DISPID_STATUSTEXTCHANGE

    .Else_If D@dispIdMember = &DISPID_PROGRESSCHANGE

    .Else_If D@dispIdMember = &DISPID_TITLECHANGE

    .Else_If D@dispIdMember = &DISPID_BEFORENAVIGATE2
        ;OutPutStringLiteral "BeforeNav2 Event Occured"

    .Else_If D@dispIdMember = &DISPID_PROPERTYCHANGE

    .Else_If D@dispIdMember = &DISPID_NEWWINDOW2
        ;OutPutStringLiteral "NewWindow2 Event Occured"

    .Else_If D@dispIdMember = &DISPID_NAVIGATECOMPLETE2
        ;OutPutStringLiteral "NavComplete2 Event Occured"

    .Else_If D@dispIdMember = &DISPID_DOCUMENTCOMPLETE
        ;OutPutStringLiteral "Document Complete Event Occured"

    .Else_If D@dispIdMember = &DISPID_ONQUIT

    .Else_If D@dispIdMember = &DISPID_ONVISIBLE

    .Else_If D@dispIdMember = &DISPID_ONTOOLBAR

    .Else_If D@dispIdMember = &DISPID_ONMENUBAR

    .Else_If D@dispIdMember = &DISPID_ONSTATUSBAR

    .Else_If D@dispIdMember = &DISPID_ONFULLSCREEN

    .Else_If D@dispIdMember = &DISPID_ONTHEATERMODE

    .Else_If D@dispIdMember = 270
        ;OutPutStringLiteral "FileDownload Event Occured"

    .Else_If D@dispIdMember = &DISPID_DOWNLOADBEGIN
        ;OutPutStringLiteral "Download Begin Event Occured"

    .Else_If D@dispIdMember = &DISPID_DOWNLOADCOMPLETE
        ;OutPutStringLiteral "Download Complete Event Occured"

    .Else_If D@dispIdMember = &DISPID_TITLEICONCHANGE
        ;OutPutStringLiteral "TitleChange Event Occured"

    .End_if

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Called from IE4/MSHTML when it is about to show its context menu.
Proc IDocHostUIHandler.ShowContextMenu:
    Arguments @pif, @dwID, @ppt, @pcmdtReserved, @pdispReserved
    return &E_FAIL
EndP
____________________________________________________________________________________________

;Retrieves the UI capabilities of the IE4/MSHTML host.
Proc IDocHostUIHandler.GetHostInfo:
    Arguments @pif, @pInfo
    Uses edi

    mov edi D@pInfo | mov D$edi 20
    mov D$edi+4 &DOCHOSTUIFLAG_DIALOG+&DOCHOSTUIFLAG_DISABLE_HELP_MENU+&DOCHOSTUIFLAG_FLAT_SCROLLBAR
    return &S_OK

 EndP
____________________________________________________________________________________________

;Allows the host to replace the IE4/MSHTML menus and toolbars.
Proc IDocHostUIHandler.ShowUI:
    Arguments @pif, @dwID, @pActiveObject, @pCommandTarget, @pFrame, @pDoc

    return &E_NOTIMPL
EndP
_______________________________________________________________________________

;Called when IE4/MSHTML removes its menus and toolbars.
Proc IDocHostUIHandler.HideUI:
    Argument @pif

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Notifies the host that the command state has changed.
Proc IDocHostUIHandler.UpdateUI:
    Argument @pif

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Called from the IE4/MSHTML implementation ofIOleInPlaceActiveObject::EnableModeless.
;Also called when IE4/MSHTML displays modal UI. The host should enable or disable its
;modeless UI as appropriate.
Proc IDocHostUIHandler.EnableModeless:
    Arguments @pif, @fEnable

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Called from the IE4/MSHTML implementation ofIOleInPlaceActiveObject::OnDocWindowActivate.
Proc IDocHostUIHandler.OnDocWindowActivate:
    Arguments @pif, @fActivate

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Called from the IE4/MSHTML implementation ofIOleInPlaceActiveObject::OnFrameWindowActivate.
Proc IDocHostUIHandler.OnFrameWindowActivate:
    Arguments @pif, @fActivate

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Called from the IE4/MSHTML implementation ofIOleInPlaceActiveObject::ResizeBorder.
Proc IDocHostUIHandler.ResizeBorder:
    Arguments @pif, @prcBorder, @pUIWindow, @fRameWindow

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

; Called by IE4/MSHTML whenIOleInPlaceActiveObject::TranslateAccelerator or
; IOleControlSite::TranslateAccelerator is called.
Proc IDocHostUIHandler.TranslateAccelerator:
    Arguments @pif, @lpMsg, @pguidCmdGroup, @nCmdID

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

; Returns the registry key under which IE4/MSHTML stores user preferences.
Proc IDocHostUIHandler.GetOptionKeyPath:
    Arguments @pif, @pchKey, @dw

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Called by IE4/MSHTML when it is being used as a drop target to allow the host to
;supply an alternativeIDropTarget
Proc IDocHostUIHandler.GetDropTarget:
    Arguments @pif, @pDropTarget, @ppDropTarget

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Called by IE4/MSHTML to obtain the host's IDispatch interface.
Proc IDocHostUIHandler.GetExternal:
    Arguments @pif, @ppDispatch

    mov eax D@ppDispatch
    mov ebx D@pif
    mov D$eax ebx
    return &S_OK
EndP
____________________________________________________________________________________________

; Called by IE4/MSHTML to allow the host an opportunity to modify the URL to be loaded.
Proc IDocHostUIHandler.TranslateUrl:
    Arguments @pif, @dwTranslate, @pchURLIn, @ppchURLOut

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

;Called on the host by IE4/MSHTML to allow the host to replace IE4/MSHTML's data object.
;This allows the host to block certain clipboard formats or support additional clipboard formats.
Proc IDocHostUIHandler.FilterDataObject:
    Arguments @pif, @pDO, @ppDORet

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

; Called by IE4/MSHTML when it needs to show Help.
Proc IDocHostShowUI.ShowHelp:
    Arguments @pif, @hWnd, @pszHelpFile, @uCommand, @dwData, @ptMouse, @pDispatchObjectHit

    return &E_NOTIMPL
EndP
____________________________________________________________________________________________

; Called by IE4/MSHTML when it needs to display a message box.
Proc IDocHostShowUI.ShowMessage:
    Arguments @pif, @hwnd, @lpstrText, @lpstrCaption, @dwType, @lpstrHelpFile, @dwHelpContext, @plResult

    .If D@dwHelpContext <> 0
        call 'USER32.MessageBoxA' D@pif D@lpstrText BrowserTitle D@lpstrCaption
        returns D@plResult
    .Else
        call 'USER32.MessageBoxA' D@pif D@lpstrText BrowserTitle D@lpstrCaption
    .End_If

    return 0
EndP
____________________________________________________________________________________________

Main:
    call 'KERNEL32.GetModuleHandleA' 0 | mov D$hInstance eax
    call 'USER32.LoadCursorA' 0 &IDC_ARROW | mov D$hCursor eax

    ;Initialize the COM library
    call 'ole32.CoInitialize' &NULL
    If eax = &S_OK
        ; Create our embedded IE web browser!
        call CreateBrowserWindow
        ;Close the COM library
        call 'ole32.CoUninitialize'
    End_If

    call 'KERNEL32.ExitProcess' eax
ret
____________________________________________________________________________________________

CreateBrowserWindow:
    call 'USER32.RegisterClassExA' WindowClassEx
    call 'USER32.CreateWindowExA' &WS_EX_LEFT MyClass BrowserTitle &WS_OVERLAPPEDWINDOW,
                                  50 50 600 400  &NULL &NULL D$hInstance &NULL
    mov D$hWnd eax

    ; After normal window creation, here is where it all begins.
    call CreateEmbeddedBrowser D$hWnd 0

    call 'USER32.ShowWindow' D$hWnd &SW_MAXIMIZE
    call 'USER32.UpdateWindow' D$hWnd
L1:
    call 'User32.GetMessageA' FirstMessage 0 0 0
    cmp eax 0 | je Q9>
        call 'User32.TranslateMessage' FirstMessage
        call 'User32.DispatchMessageA' FirstMessage
    jmp L1<
Q9: ret
____________________________________________________________________________________________

Proc MainWindowProc:
    Arguments @hWnd, @Message, @wParam, @lParam

    .If D@Message = &WM_SIZE
        call ResizeBrowser
        return 0

    .Else_If D@Message = &WM_DESTROY
        call DestroyBrowser
        call 'USER32.PostQuitMessage' 0
        return 0

    .End_if

    call 'USER32.DefWindowProcA' D@hWnd, D@Message, D@wParam, D@lParam

EndP

